/* Modification of cmdlinespeak source included in ViaVoice
OutLoud package. */

// First created:  Dec 13, 1999
// Modified by:  Andrew Plumb
// E-mail me at:  andrew@plumb.org

// Requires IBM's ViaVoice Outloud Runtime kit for speech synthesis package,
// available at:
//   http://www.ibm.com/viavoice/dev_home.html

// Application to Output text from the command line
// Modified from original pipespeak.cpp to include switches for setting
// voice used.

#include <eci.h>
#include <string.h>
#include <memory.h>
#include <iostream.h>
#include <iomanip.h>

int main (int argc, char * argv[])
{
  int ret;
  int maxlength=255;
  int lineNum = 1;
  char speakervoice[maxlength]; 
  ECIHand hECI;
  char lineread[maxlength]; 
  char endspeak[maxlength];

  endspeak="`v2 Finished.\n";

  hECI = eciNew();
// create a new ECI instance
#ifdef FILEOUTPUT
  // output to file - set name to temp.au
  ret=eciSetOutputFilename(hECI,"temp.au");
  // cout << "ret=" << ret << " from eciSetOutputFilename\n";
#else
  // output to device - default device is 0
  ret=eciSetOutputDevice(hECI, 0);
  // cout << "ret=" << ret << " from eciSetOutputDevice\n";
#endif

// Read in switches for setting the initial voice
  strcpy(speakervoice,"");
  strcpy(lineread,"");
  if ( argc >= 2 ) {
	char temp[maxlength];
	// speak all arguments; change switches into ` format voice commands
	for (int i=1; i<argc; i++) {
		strcpy(temp,argv[i]);
		if(temp[0]=='-') {
			if (strcmp(temp,"-done")==0) {
				strcpy(endspeak,argv[++i]);
				strcpy(temp,"");
			//	i++;
			} else {
				temp[0]='`';
			}
		} else if (temp[0]=='"') {
			while (temp[strlen(temp)] != '"') {
				strcat(speakervoice,temp);
				strcat(speakervoice," ");
				strcpy(temp,argv[++i]);
			}
		}
		strcat(temp," ");
		strcat(speakervoice,temp);
	}
	strcpy(lineread,speakervoice);
//	cout << speakervoice << endl;

	ret=eciSetParam(hECI,eciInputType,1);
	ret=eciAddText(hECI,lineread);
	ret=eciSynthesize(hECI);
	ret=eciSynchronize(hECI);
  } 

  while ( !cin.fail() && !cin.eof() ) {
	// Get next line of text and echo
	cin.getline( lineread, maxlength+1 );
	cout << lineread << endl;

	// set engine to parse annotated text
	ret=eciSetParam(hECI,eciInputType,1);
 	// Add text to engine
	ret=eciAddText(hECI,lineread);
	// cout << "ret=" << ret << " from eciAddText\n";

	// Begin synthesis of Text
	ret=eciSynthesize(hECI);
	// cout << "ret=" << ret << " from eciSynthesize\n";

	// Synchronize. This will wait until all text is processed.
	ret=eciSynchronize(hECI);
	// cout << "ret=" << ret << " from eciSynchronize\n";

  }
  if ( cin.fail() && !cin.eof() ) {
	cerr << "Unable to open pipe for input" << endl;
  } else {
	strcat(lineread,endspeak);
//	cout << lineread;
	ret=eciSetParam(hECI,eciInputType,1);
	ret=eciAddText(hECI,lineread);
	ret=eciSynthesize(hECI);
	ret=eciSynchronize(hECI);
  }
  // Delete the instance
  eciDelete(hECI);
	
  return 0;
}

